<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePayrollMastersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('payroll_masters')) {
            Schema::create('payroll_masters', function (Blueprint $table) {
                $table->increments('id');
                $table->timestamps();

                $table->unsignedInteger('created_by');
                $table->unsignedInteger('last_updated_by')->nullable();

                $table->unsignedInteger('staff_id');
                $table->string('tag_line', '100');
                $table->string('payroll_head', '50');
                $table->dateTime('due_date');
                $table->integer('amount');
                $table->boolean('status')->default(1);

                $table->foreign('staff_id')->references('id')->on('staff');
            });

        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payroll_masters');
    }
}
