<div class="table-responsive">
    <table id="dynamic-table" class="table table-striped table-bordered table-hover">
        <thead>
            <tr>
                <th><?php echo e(__('common.s_n'), false); ?></th>
                <th><?php echo e(__('form_fields.student.fields.faculty'), false); ?></th>
                <th><?php echo e(__('form_fields.student.fields.semester'), false); ?></th>
                <th><?php echo e(__('form_fields.student.fields.reg_no'), false); ?></th>
                <th><?php echo e(__('form_fields.student.fields.name_of_student'), false); ?></th>
                <th>DateofBirth</th>
                
            </tr>
        </thead>
        <tbody>
        <?php if(isset($data['student_birthday']) && $data['student_birthday']->count() > 0): ?>
            <?php ($i=1); ?>
            <?php ($todayMonthDay = today()->format('m-d')); ?>
            <?php $__currentLoopData = $data['student_birthday']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($i, false); ?></td>
                    <td> <?php echo e(ViewHelper::getFacultyTitle( $student->faculty ), false); ?></td>
                    <td> <?php echo e(ViewHelper::getSemesterTitle( $student->semester ), false); ?></td>
                    
                    <td><a href="<?php echo e(route('student.view', ['id' => encrypt($student->id)]), false); ?>"><?php echo e($student->reg_no, false); ?></a></td>
                    <td><a href="<?php echo e(route('student.view', ['id' => encrypt($student->id)]), false); ?>"> <?php echo e($student->first_name.' '.$student->middle_name.' '. $student->last_name, false); ?></a></td>
                    <td>
                        <?php ($birthdayMonthDay = \Carbon\Carbon::parse($student->date_of_birth)->format('m-d')); ?>
                        <?php if($todayMonthDay ==$birthdayMonthDay): ?>
                            <div class="label label-success ">
                                <?php echo e(\Carbon\Carbon::parse($student->date_of_birth)->format('Y-m-d'), false); ?>

                            </div>
                        <?php else: ?>
                            <?php echo e(\Carbon\Carbon::parse($student->date_of_birth)->format('Y-m-d'), false); ?>

                        <?php endif; ?>
                    </td>
                    
                </tr>
                <?php ($i++); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <tr>
                <td colspan="7">No Birthday data found.</td>
            </tr>
        <?php endif; ?>
        </tbody>
        <tfoot>
            <tr>
                <td class="text-center" colspan="6"><?php echo $data['staff_birthday']->appends($data['filter_query'])->links(); ?></td>
            </tr>
        </tfoot>
    </table>
</div>
<?php /**PATH C:\laragon\www\edufirm\resources\views/dashboard/includes/birthday/student.blade.php ENDPATH**/ ?>