<div id="sidebar" class="sidebar h-sidebar navbar-collapse collapse ace-save-state hidden-print">
    <script type="text/javascript">
        try{ace.settings.loadState('sidebar')}catch(e){}
    </script>

    <div class="sidebar-shortcuts" id="sidebar-shortcuts">
        <div class="sidebar-shortcuts-large" id="sidebar-shortcuts-large">
            <a class="btn btn-success" href="<?php echo e(route('dashboard'), false); ?>" title="Dashboard">
                <i class="ace-icon fa fa-signal"></i>
            </a>

            <a class="btn btn-info" href="<?php echo e(route('account.fees.quick-receive'), false); ?>">
                <i class="ace-icon fa fa-calculator"></i>
            </a>

            <a class="btn btn-warning" href="<?php echo e(route('user'), false); ?>">
                <i class="ace-icon fa fa-users"></i>
            </a>

            <a class="btn btn-danger" href="<?php echo e(route('setting.general'), false); ?>">
                <i class="ace-icon fa fa-cogs"></i>
            </a>


        </div>

        <div class="sidebar-shortcuts-mini" id="sidebar-shortcuts-mini">
            <span class="btn btn-success"></span>

            <span class="btn btn-info"></span>

            <span class="btn btn-warning"></span>

            <span class="btn btn-danger"></span>
        </div>
    </div>
    <!-- /.sidebar-shortcuts -->

    <ul class="nav nav-list hidden-print">
        
        <li class="<?php echo request()->is('dashboard')?'active':''; ?>">
            <a href="<?php echo e(route('dashboard'), false); ?>" >
                <i class="menu-icon fa fa-tachometer"></i>
                <span class="menu-text"> <?php echo e(__('dashboard.name'), false); ?> </span>
            </a>
        </li>

        
        <?php if (\Entrust::ability('super-admin','web-cms')) : ?>
            <?php if( isset($generalSetting) && $generalSetting->web_cms ==1): ?>
                <li class="<?php echo request()->is('web*')?'active open':''; ?>  hover">
                    <a href="<?php echo e(route('web.admin.dashboard'), false); ?>">
                        <i class="menu-icon fa fa-globe" aria-hidden="true"></i>
                        <span class="menu-text"><?php echo e(__('web_cms.name'), false); ?> </span>

                        <b class="arrow fa fa-angle-down"></b>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        <?php if (\Entrust::ability('super-admin','front-office')) : ?>
            <?php if( isset($generalSetting) && $generalSetting->front_desk ==1): ?>
                <li class="<?php echo request()->is('front*')?'active open':''; ?> hover">
                    <a href="#" class="dropdown-toggle">
                        <i class="menu-icon  fa fa-comment" aria-hidden="true"></i>
                        <span class="menu-text"><?php echo e(__('front_desk.name'), false); ?></span>
                        <b class="arrow fa fa-angle-down"></b>
                    </a>

                    <b class="arrow"></b>

                    <ul class="submenu">
                        <li class="hover">
                            <a href="<?php echo e(route('front.postal-exchange'), false); ?>">
                                <i class="menu-icon fa fa-caret-right"></i>
                                <?php echo e(__('front_desk.child.postal_exchange'), false); ?>

                            </a>
                        </li>

                        <li class="hover">
                            <a href="<?php echo e(route('front.visitor'), false); ?>">
                                <i class="menu-icon fa fa-caret-right"></i>
                                <?php echo e(__('front_desk.child.visitor_log'), false); ?>

                            </a>
                        </li>

                        
                    </ul>
                </li>
            <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        
        <?php if (\Entrust::ability('super-admin','student-staff')) : ?>
            <?php if( isset($generalSetting) && $generalSetting->student_staff ==1): ?>
                <li class="<?php echo request()->is('student*')||request()->is('staff*')?'active open':''; ?>  hover">
                    <a href="#" class="dropdown-toggle">
                        <i class="menu-icon fa fa-users" aria-hidden="true"></i>
                        <span class="menu-text"><?php echo e(__('student_staff.name'), false); ?></span>

                        <b class="arrow fa fa-angle-down"></b>
                    </a>

                    <b class="arrow"></b>

                    <ul class="submenu">
                        <li class="<?php echo request()->is('student*')?'active open':''; ?> hover">
                            <a href="#" class="dropdown-toggle">
                                <i class="menu-icon fa fa-caret-right"></i>
                                <?php echo e(__('student_staff.child.student.name'), false); ?>

                                <b class="arrow"></b>
                            </a>
                            <b class="arrow"></b>
                            <ul class="submenu">
                                <li class="<?php echo request()->is('student')?'active':''; ?> hover">
                                    <a href="<?php echo e(route('student'), false); ?>" >
                                        <i class="menu-icon fa fa-caret-right"></i>
                                        <?php echo e(__('student_staff.common.detail'), false); ?>

                                    </a>

                                    <b class="arrow"></b>
                                </li>

                                <li class="<?php echo request()->is('student/registration')?'active':''; ?> hover">
                                    <a href="<?php echo e(route('student.registration'), false); ?>">
                                        <i class="menu-icon fa fa-caret-right"></i>
                                        <?php echo e(__('student_staff.common.registration'), false); ?>

                                    </a>
                                    <b class="arrow"></b>
                                </li>

                                <li class="<?php echo request()->is('student/import')?'active':''; ?> hover">
                                    <a href="<?php echo e(route('student.import'), false); ?>">
                                        <i class="menu-icon fa fa-caret-right"></i>
                                        <?php echo e(__('student_staff.common.bulk_import'), false); ?>

                                    </a>
                                    <b class="arrow"></b>
                                </li>

                                <li class="<?php echo request()->is('student/transfer')?'active':''; ?> hover">
                                    <a href="<?php echo e(route('student.transfer'), false); ?>">
                                        <i class="menu-icon fa fa-caret-right"></i>
                                        <?php echo e(__('student_staff.child.student.child.transfer'), false); ?>

                                    </a>

                                    <b class="arrow"></b>
                                </li>
                                <li class="<?php echo request()->is('student/document')?'active':''; ?> hover">
                                    <a href="<?php echo e(route('student.document'), false); ?>"  >
                                        <i class="menu-icon fa fa-caret-right"></i>
                                        <?php echo e(__('student_staff.common.document_upload'), false); ?>

                                    </a>
                                    <b class="arrow"></b>
                                </li>

                                <li class="<?php echo request()->is('student/note')?'active':''; ?> hover">
                                    <a href="<?php echo e(route('student.note'), false); ?>">
                                        <i class="menu-icon fa fa-caret-right"  ></i>
                                        <?php echo e(__('student_staff.common.notes'), false); ?>

                                    </a>
                                    <b class="arrow"></b>
                                </li>
                                <li class="<?php echo request()->is('report/student*')?'active':''; ?> hover">
                                    <a href="<?php echo e(route('report.student'), false); ?>">
                                        <i class="menu-icon fa fa-caret-right"></i>
                                        <?php echo e(__('student_staff.common.complete_records'), false); ?>

                                    </a>

                                    <b class="arrow"></b>
                                </li>
                            </ul>
                        </li>

                        <li class="<?php echo request()->is('guardian*')?'active open':''; ?> hover">
                            <a href="#" class="dropdown-toggle">
                                <i class="menu-icon fa fa-caret-right"></i>
                                <?php echo e(__('student_staff.child.guardian.name'), false); ?>

                                <b class="arrow"></b>
                            </a>
                            <b class="arrow"></b>
                            <ul class="submenu">
                                <li class="<?php echo request()->is('guardian')?'active':''; ?> hover">
                                    <a href="<?php echo e(route('guardian'), false); ?>" >
                                        <i class="menu-icon fa fa-caret-right"></i>
                                        <?php echo e(__('student_staff.common.detail'), false); ?>

                                    </a>

                                    <b class="arrow"></b>
                                </li>

                                <li class="<?php echo request()->is('guardian/registration')?'active':''; ?> hover">
                                    <a href="<?php echo e(route('guardian.registration'), false); ?>">
                                        <i class="menu-icon fa fa-caret-right"></i>
                                        <?php echo e(__('student_staff.common.registration'), false); ?>

                                    </a>

                                    <b class="arrow"></b>
                                </li>
                            </ul>
                        </li>

                        <li class="<?php echo request()->is('staff*')?'active open':''; ?> hover">
                            <a href="#" class="dropdown-toggle">
                                <i class="menu-icon fa fa-caret-right"></i>
                                <?php echo e(__('student_staff.child.staff.name'), false); ?>

                                <b class="arrow"></b>
                            </a>
                            <b class="arrow"></b>
                            <ul class="submenu">
                                <li class="<?php echo request()->is('staff')?'active':''; ?>  hover">
                                    <a href="<?php echo e(route('staff'), false); ?>">
                                        <i class="menu-icon fa fa-caret-right"></i>
                                        <?php echo e(__('student_staff.common.detail'), false); ?>

                                    </a>

                                    <b class="arrow"></b>
                                </li>

                                <li class="<?php echo request()->is('staff/add')?'active':''; ?>  hover">
                                    <a href="<?php echo e(route('staff.add'), false); ?>">
                                        <i class="menu-icon fa fa-caret-right"></i>
                                        <?php echo e(__('student_staff.common.registration'), false); ?>

                                    </a>

                                    <b class="arrow"></b>
                                </li>
                                <li class="<?php echo request()->is('staff/import')?'active':''; ?> hover">
                                    <a href="<?php echo e(route('staff.import'), false); ?>">
                                        <i class="menu-icon fa fa-caret-right"></i>
                                        <?php echo e(__('student_staff.common.bulk_import'), false); ?>

                                    </a>
                                    <b class="arrow"></b>
                                </li>

                                <li class="<?php echo request()->is('staff/document')?'active':''; ?> hover">
                                    <a href="<?php echo e(route('staff.document'), false); ?>"  >
                                        <i class="menu-icon fa fa-caret-right"></i>
                                        <?php echo e(__('student_staff.common.document_upload'), false); ?>

                                    </a>
                                    <b class="arrow"></b>
                                </li>

                                <li class="<?php echo request()->is('staff/note')?'active':''; ?> hover">
                                    <a href="<?php echo e(route('staff.note'), false); ?>">
                                        <i class="menu-icon fa fa-caret-right"  ></i>
                                        <?php echo e(__('student_staff.common.notes'), false); ?>

                                    </a>
                                    <b class="arrow"></b>
                                </li>

                                <li class="<?php echo request()->is('staff/designation')?'active':''; ?> hover">
                                    <a href="<?php echo e(route('staff.designation'), false); ?>">
                                        <i class="menu-icon fa fa-caret-right"  ></i>
                                        <?php echo e(__('student_staff.child.staff.child.designation'), false); ?>

                                    </a>
                                    <b class="arrow"></b>
                                </li>

                                <li class="<?php echo request()->is('report/staff*')?'active':''; ?> hover">
                                    <a href="<?php echo e(route('report.staff'), false); ?>">
                                        <i class="menu-icon fa fa-caret-right"></i>
                                        <?php echo e(__('student_staff.common.complete_records'), false); ?>


                                    </a>

                                    <b class="arrow"></b>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </li>
            <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        
        <?php if (\Entrust::ability('super-admin','account')) : ?>
        <?php if( isset($generalSetting) && $generalSetting->account ==1): ?>
            <li class="<?php echo request()->is('account/*')?'active open':''; ?>  hover">
                <a href="#" class="dropdown-toggle">
                    <i class="menu-icon fa fa-calculator" aria-hidden="true"></i>
                    <span class="menu-text"> <?php echo e(__('account.name'), false); ?></span>

                    <b class="arrow fa fa-angle-down"></b>
                </a>

                <b class="arrow"></b>

                <ul class="submenu">
                    <li class="<?php echo request()->is('account/fees*')?'active open':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <i class="fa fa-calculator"></i>  <?php echo e(__('account.child.fees.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('account/fees')?'active':''; ?>  hover">
                                <a href="<?php echo e(route('account.fees'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.fees.child.detail'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/fees/quick-receive')?'active':''; ?>  hover">
                                <a href="<?php echo e(route('account.fees.quick-receive'), false); ?>" >
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.fees.child.quick_receive'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/fees/collection')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.fees.collection'), false); ?>" >
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.fees.child.collection'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/fees/balance')?'active':''; ?>  hover">
                                <a href="<?php echo e(route('account.fees.balance'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.fees.child.balance'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/fees/master/add')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.fees.master.add'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.fees.child.add'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/fees/online-payment')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.fees.online-payment'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.fees.child.online_payment'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/fees/head')?'active':''; ?>  hover">
                                <a href="<?php echo e(route('account.fees.head'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.fees.child.head'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                        </ul>
                    </li>

                    <li class="divider"></li>
                    <li class="<?php echo request()->is('account/report*')?'active open':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <i class="fa fa-print"></i>  <?php echo e(__('account.child.fee_report.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('account/report/cash-book*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.report.cash-book'), false); ?>">
                                    <i class="menu-icon fa fa-rupee"></i>
                                    <?php echo e(__('account.child.fee_report.child.cash_book'), false); ?>

                                </a>
                            </li>

                            <li class="<?php echo request()->is('account/report/fee-collection')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.report.fee-collection'), false); ?>">
                                    <i class="menu-icon fa fa-calculator"></i>
                                    <?php echo e(__('account.child.fee_report.child.fee_collection'), false); ?>

                                </a>
                            </li>

                            <li class="<?php echo request()->is('account/report/fee-online-payment')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.report.fee-online-payment'), false); ?>">
                                    <i class="menu-icon fa fa-globe"></i>
                                    <?php echo e(__('account.child.fee_report.child.online_payment'), false); ?>

                                </a>
                            </li>

                            <li class="<?php echo request()->is('account/report/fee-collection-head*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.report.fee-collection-head'), false); ?>">
                                    <i class="menu-icon fa fa-calculator"></i>
                                    <?php echo e(__('account.child.fee_report.child.fee_collection_head'), false); ?>

                                </a>
                            </li>

                            <li class="<?php echo request()->is('account/report/balance-fee*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.report.balance-fee'), false); ?>">
                                    <i class="menu-icon fa fa-calculator"></i>
                                    <?php echo e(__('account.child.fee_report.child.fee_balance'), false); ?>

                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class="divider"></li>

                    <li class="<?php echo request()->is('account.transaction*')?'active open':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <i class="fa fa-newspaper-o"></i> <?php echo e(__('account.child.ledger_transaction.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('account/transaction/add')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.transaction.add'), false); ?>">
                                    <i class="menu-icon fa fa-plus"></i>
                                    <?php echo e(__('account.child.ledger_transaction.child.transaction'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/transaction/multi-add')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.transaction.multi-add'), false); ?>">
                                    <i class="menu-icon fa fa-plus"></i>
                                    <?php echo e(__('account.child.ledger_transaction.child.multi'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/transaction')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.transaction'), false); ?>" >
                                    <i class="menu-icon fa fa-list"></i>
                                    <?php echo e(__('account.child.ledger_transaction.child.detail'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/transfer')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.transfer'), false); ?>">
                                    <i class="menu-icon fa fa-exchange"></i>
                                    <?php echo e(__('account.child.ledger_transaction.child.transfer'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/transaction-head')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.transaction-head'), false); ?>">
                                    <i class="menu-icon fa fa-newspaper-o"></i>
                                    <?php echo e(__('account.child.ledger_transaction.child.transaction_head'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/transaction/account-group')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.transaction.account-group'), false); ?>">
                                    <i class="menu-icon fa fa-newspaper-o"></i>
                                    <?php echo e(__('account.child.ledger_transaction.child.account_groups'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('account/transaction/account-group/chart-of-account')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.transaction.account-group.chart-of-account'), false); ?>">
                                    <i class="menu-icon fa fa-newspaper-o"></i>
                                    <?php echo e(__('account.child.ledger_transaction.child.charts_of_account'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                        </ul>
                    </li>

                    <li class="<?php echo request()->is('account/bank*')?'active open':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <i class="fa fa-bank"></i> <?php echo e(__('account.child.banking.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('account/bank')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.bank'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.banking.child.manage_bank_account'), false); ?>

                                </a>
                            </li>
                            <li class="<?php echo request()->is('account/bank/add')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.bank.add'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.banking.child.add_new_bank'), false); ?>

                                </a>
                            </li>

                            <li class="<?php echo request()->is('account/bank-transaction')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.bank-transaction'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.banking.child.transaction_detail'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/bank-transaction/add')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.bank-transaction.add'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.banking.child.new_transaction'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                        </ul>
                    </li>

                    <li class="divider"></li>

                    <li class="<?php echo request()->is('account/payroll*')?'active open':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <i class="fa fa-user-secret"></i>  <?php echo e(__('account.child.payroll.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('account/payroll')?'active':''; ?>  hover">
                                <a href="<?php echo e(route('account.payroll'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.payroll.child.paid_detail'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/salary/payment')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.salary.payment'), false); ?>" >
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.payroll.child.payment'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/payroll/master*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.payroll.master.add'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.payroll.child.add'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/payroll/balance')?'active':''; ?>  hover">
                                <a href="<?php echo e(route('account.payroll.balance'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.payroll.child.balance'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('account/payroll/head')?'active':''; ?>  hover">
                                <a href="<?php echo e(route('account.payroll.head'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('account.child.payroll.child.head'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                        </ul>
                    </li>
                    <li class="divider"></li>
                    <li class="<?php echo request()->is('account/report*')?'active open':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <i class="fa fa-print"></i> <?php echo e(__('account.child.account_report.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('account/transaction-head/view*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.transaction-head.view'), false); ?>">
                                    <i class="menu-icon fa fa-newspaper-o"></i>
                                    <?php echo e(__('account.child.account_report.child.statement'), false); ?>

                                </a>
                            </li>
                            <li class="<?php echo request()->is('account/transaction-head/balance-statement*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.transaction-head.balance-statement'), false); ?>" >
                                    <i class="menu-icon fa fa-newspaper-o"></i>
                                    <?php echo e(__('account.child.account_report.child.balance'), false); ?>

                                </a>
                            </li>

                            <li class="<?php echo request()->is('account/transaction/account-group/chart-of-account')?'active':''; ?> hover">
                                <a href="<?php echo e(route('account.transaction.account-group.chart-of-account'), false); ?>">
                                    <i class="menu-icon fa fa-newspaper-o"></i>
                                    <?php echo e(__('account.child.account_report.child.coa'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>
                        </ul>
                    </li>

                </ul>
            </li>
        <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        <?php if (\Entrust::ability('super-admin','inventory')) : ?>
        <?php if( isset($generalSetting) && $generalSetting->inventory ==1): ?>
            <li class="<?php echo request()->is('inventory*')?'active open':''; ?> hover">
                <a href="#" class="dropdown-toggle">
                    <i class="menu-icon fa fa-shopping-cart"></i>
                    <?php echo e(__('inventory.name'), false); ?>

                    <b class="arrow"></b>
                </a>
                <b class="arrow"></b>
                <ul class="submenu">
                    <li class="<?php echo request()->is('inventory/assets*') || request()->is('inventory/sem-assets*')?'active open':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <i class="fa fa-store"></i> <?php echo e(__('inventory.child.class_assets.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('inventory/assets')?'active':''; ?> hover">
                                <a href="<?php echo e(route('inventory.assets'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('inventory.child.class_assets.child.assets'), false); ?>

                                </a>
                            </li>
                            <li class="<?php echo request()->is('inventory/sem-assets')?'active':''; ?> hover">
                                <a href="<?php echo e(route('inventory.sem-assets'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('inventory.child.class_assets.child.faculty_sem_assets'), false); ?>

                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="<?php echo request()->is('inventory/product*')?'active open':''; ?>  hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <span class="menu-text"><?php echo e(__('inventory.child.assets.name'), false); ?></span>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('inventory/product/registration*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('inventory.product.registration'), false); ?>" >
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <i class="fa fa-plus"></i> <?php echo e(__('inventory.child.assets.child.add'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('inventory/product')?'active':''; ?> hover">
                                <a href="<?php echo e(route('inventory.product'), false); ?>" >
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <i class="fa fa-list"></i> <?php echo e(__('inventory.child.assets.child.detail'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('inventory/product/category*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('inventory.product.category'), false); ?>" >
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <i class="fa fa-list-alt"></i> <?php echo e(__('inventory.child.assets.child.category'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                        </ul>
                    </li>

                    <li class="<?php echo request()->is('inventory/customer*')?'active open':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('inventory.child.customer.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('inventory/customer')?'active':''; ?> hover">
                                <a href="<?php echo e(route('inventory.customer'), false); ?>" >
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('inventory.child.customer.child.detail'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('inventory/customer/registration')?'active':''; ?> hover">
                                <a href="<?php echo e(route('inventory.customer.registration'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('inventory.child.customer.child.register'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('inventory/customer/document')?'active':''; ?> hover">
                                <a href="<?php echo e(route('inventory.customer.document'), false); ?>"  >
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('inventory.child.customer.child.documents'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('inventory/customer/note')?'active':''; ?> hover">
                                <a href="<?php echo e(route('inventory.customer.note'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"  ></i>
                                    <?php echo e(__('inventory.child.customer.child.notes'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>
                        </ul>
                    </li>

                    <li class="<?php echo request()->is('inventory/vendor*')?'active open':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('inventory.child.vendor.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('inventory/vendor')?'active':''; ?> hover">
                                <a href="<?php echo e(route('inventory.vendor'), false); ?>" >
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('inventory.child.vendor.child.detail'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('inventory/vendor/registration')?'active':''; ?> hover">
                                <a href="<?php echo e(route('inventory.vendor.registration'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('inventory.child.vendor.child.register'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('inventory/vendor/document')?'active':''; ?> hover">
                                <a href="<?php echo e(route('inventory.vendor.document'), false); ?>"  >
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('inventory.child.vendor.child.documents'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('inventory/vendor/note')?'active':''; ?> hover">
                                <a href="<?php echo e(route('inventory.vendor.note'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"  ></i>
                                    <?php echo e(__('inventory.child.vendor.child.notes'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>
                        </ul>
                    </li>







































































                    

                </ul>
            </li>
        <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        
        <?php if (\Entrust::ability('super-admin','library')) : ?>
        <?php if( isset($generalSetting) && $generalSetting->library ==1): ?>
            <li class="<?php echo request()->is('library*')?'active':''; ?> hover">
                <a href="#" class="dropdown-toggle">
                    <i class="menu-icon fa fa-book" aria-hidden="true"></i>
                    <span class="menu-text">
                        <?php echo e(__('library.name'), false); ?>

                    </span>

                    <b class="arrow fa fa-angle-down"></b>
                </a>
                <b class="arrow"></b>

                <ul class="submenu">
                    <li class="<?php echo request()->is('library/book*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('library.book'), false); ?>"  class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('library.child.books.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('library/member*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('library.book'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('library.child.books.child.detail'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('library/book/add*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('library.book.add'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('library.child.books.child.new'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('library/book/import*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('library.book.import'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('library.child.books.child.import'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>


                            <li class="<?php echo request()->is('library/book/category*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('library.book.category'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('library.child.books.child.category'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                        </ul>
                    </li>

                    <li class="<?php echo request()->is('library/member*') || request()->is('library/student*') || request()->is('library/staff*') ?'active':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('library.child.members.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('library/member*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('library.member'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('library.child.members.child.membership'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('library/student*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('library.student'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('library.child.members.child.student'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('library/staff*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('library.staff'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('library.child.members.child.staff'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                        </ul>
                    </li>

                    <li class="<?php echo request()->is('library/request*') ?'active':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('library.child.book_request.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('library/request-student*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('library.student-request'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('library.child.book_request.child.student'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('library/request-staff*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('library.staff-request'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('library.child.book_request.child.staff'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                        </ul>
                    </li>

                    <li class="<?php echo request()->is('library/issue-history*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('library.issue-history'), false); ?>">
                            <i class="menu-icon fa fa-history"></i>
                            <?php echo e(__('library.child.issue_history.name'), false); ?>

                        </a>

                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('library/return-over*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('library.return-over'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('library.child.return_period_over.name'), false); ?>

                        </a>

                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('library/circulation*')?'active':''; ?>  hover">
                        <a href="<?php echo e(route('library.circulation'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('library.child.circulation_setting.name'), false); ?>

                        </a>

                        <b class="arrow"></b>
                    </li>
                </ul>
            </li>
        <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        
        <?php if (\Entrust::ability('super-admin','attendance')) : ?>
        <?php if( isset($generalSetting) && $generalSetting->attendance ==1): ?>
            <li class="<?php echo request()->is('attendance*')?'active':''; ?> hover">
                <a href="#" class="dropdown-toggle">
                    <i class="menu-icon fa fa-calendar" aria-hidden="true"></i>
                    <span class="menu-text">
                    <?php echo e(__('attendance.name'), false); ?>

                    </span>
                    <b class="arrow fa fa-angle-down"></b>
                </a>
                <b class="arrow"></b>
                <ul class="submenu">
                    <li class="hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('attendance.child.student.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('attendance/student*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('attendance.student'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('attendance.child.student.child.regular'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('attendance/subject*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('attendance.subject'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('attendance.child.student.child.subject'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                        </ul>
                    </li>

                    <li class="<?php echo request()->is('attendance/staff*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('attendance.staff'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('attendance.child.staff.name'), false); ?>

                        </a>

                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('attendance/report*')?'active open':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('attendance.child.attendance_report.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('attendance/report/student*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('attendance.report.student'), false); ?>">
                                    <i class="fa fa-calendar"></i>
                                    <?php echo e(__('attendance.child.attendance_report.child.student'), false); ?>

                                </a>
                            </li>

                            <li class="<?php echo request()->is('attendance/report/staff')?'active':''; ?> hover">
                                <a href="<?php echo e(route('attendance.report.staff'), false); ?>">
                                    <i class="fa fa-calendar"></i>
                                    <?php echo e(__('attendance.child.attendance_report.child.staff'), false); ?>

                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="<?php echo request()->is('attendance/master*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('attendance.master'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('attendance.child.monthly_calendar.name'), false); ?>

                        </a>

                        <b class="arrow"></b>
                    </li>

                </ul>
            </li>
        <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        
        <?php if (\Entrust::ability('super-admin','examination')) : ?>
        <?php if( isset($generalSetting) && $generalSetting->exam == 1): ?>
            <li class="<?php echo request()->is('exam*') || request()->is('mcq*')?'active':''; ?> hover">
                <a href="#" class="dropdown-toggle">
                    <i class="menu-icon fa fa-line-chart"  aria-hidden="true"></i>
                    <span class="menu-text">
                    <?php echo e(__('exam.name'), false); ?>

                    </span>

                    <b class="arrow fa fa-angle-down"></b>
                </a>

                <b class="arrow"></b>

                <ul class="submenu">



























































                    <li class="<?php echo request()->is('exam*')?'active':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <span class="menu-text"> Offline - Manual Exam</span>
                        </a>

                        <b class="arrow"></b>

                        <ul class="submenu">
                            <li class="<?php echo request()->is('exam/schedule*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('exam.schedule'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Schedule Exam
                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('exam/mark-ledger')?'active':''; ?>  hover">
                                <a href="<?php echo e(route('exam.mark-ledger'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Mark Ledger
                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('exam')?'active':''; ?> hover">
                                <a href="<?php echo e(route('exam'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Exams Head
                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('exam/admit-card*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('exam.admit-card'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Admit Card
                                </a>
                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('exam/routine*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('exam.routine'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Routine/Schedule
                                </a>
                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('exam/mark-sheet*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('exam.mark-sheet'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Grade/Mark/Ledger Sheet
                                </a>
                                <b class="arrow"></b>
                            </li>
                        </ul>
                    </li>


                </ul>
            </li>
        <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        
        <?php if (\Entrust::ability('super-admin','certificate')) : ?>
        <?php if( isset($generalSetting) && $generalSetting->certificate ==1): ?>
            <li class="<?php echo request()->is('certificate*')?'active':''; ?> hover">
                <a href="#" class="dropdown-toggle">
                    <i class="menu-icon fa fa-certificate"  aria-hidden="true"></i>
                    <span class="menu-text">
                    <?php echo e(__('certificate.name'), false); ?>

                    </span>

                    <b class="arrow fa fa-angle-down"></b>
                </a>

                <b class="arrow"></b>

                <ul class="submenu">
                    <li class="<?php echo request()->is('certificate/issue')?'active':''; ?> hover">
                        <a href="<?php echo e(route('certificate.issue'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Issue Certificate
                        </a>
                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('certificate/attendance*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('certificate.attendance'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Attendance Certificate
                        </a>
                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('certificate/transfer*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('certificate.transfer'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Transfer Certificate
                        </a>
                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('certificate/character*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('certificate.character'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Character Certificate
                        </a>
                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('certificate/bonafide*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('certificate.bonafide'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Bonafide Certificate
                        </a>
                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('certificate/course-completion*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('certificate.course-completion'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Course Completion Cer.
                        </a>
                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('certificate/nirgam-utara*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('certificate.nirgam-utara'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Nirgam Utara
                        </a>
                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('certificate/provisional*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('certificate.provisional'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Provisional Certificate
                        </a>
                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('certificate/testimonial*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('certificate.testimonial'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Testimonial Certificate
                        </a>
                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('certificate/moi*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('certificate.moi'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            MOI Certificate
                        </a>
                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('certificate/transcript*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('certificate.transcript'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Transcript Certificate
                        </a>
                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('certificate/issue-history*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('certificate.issue-history'), false); ?>">
                            <i class="menu-icon fa fa-history"></i>
                            Issue History
                        </a>

                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('certificate/generate*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('certificate.generate'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Custom Print
                        </a>
                        <b class="arrow"></b>
                    </li>
                    <li class="<?php echo request()->is('certificate/template*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('certificate.template'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Certificate Template
                        </a>
                        <b class="arrow"></b>
                    </li>
                </ul>
            </li>
        <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        
        <?php if (\Entrust::ability('super-admin','hostel')) : ?>
        <?php if( isset($generalSetting) && $generalSetting->hostel ==1): ?>
            <li class="<?php echo request()->is('hostel*')?'active':''; ?> hover">
                <a href="#" class="dropdown-toggle">
                    <i class="menu-icon  fa fa-bed" aria-hidden="true"></i>
                    <span class="menu-text"> <?php echo e(__('hostel.name'), false); ?> </span>
                    <b class="arrow fa fa-angle-down"></b>
                </a>
                <b class="arrow"></b>
                <ul class="submenu">
                    <li class="<?php echo request()->is('hostel/resident*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('hostel.resident'), false); ?>" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Resident
                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('hostel/resident')?'active':''; ?> hover">
                                <a href="<?php echo e(route('hostel.resident'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Detail
                                </a>
                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('hostel/resident/add')?'active':''; ?> hover">
                                <a href="<?php echo e(route('hostel.resident.add'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Registration
                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('hostel/resident/history')?'active':''; ?> hover">
                                <a href="<?php echo e(route('hostel.resident.history'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Occupant History
                                </a>
                                <b class="arrow"></b>
                            </li>

                        </ul>
                    </li>
                    <li class="<?php echo request()->is('hostel') || request()->is('hostel/room-type')?'active':''; ?> hover">
                        <a href="<?php echo e(route('hostel'), false); ?>" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Hostel
                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">

                            <li class="<?php echo request()->is('hostel*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('hostel'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Hostel
                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('hostel/room-type*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('hostel.room-type'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Room Type
                                </a>

                                <b class="arrow"></b>
                            </li>
                        </ul>
                    </li>

                    <li class="<?php echo request()->is('hostel/food*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('hostel'), false); ?>" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Food & Meal
                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('hostel/food*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('hostel.food'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Meal Schedule
                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('hostel/food/eating-time*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('hostel.food.eating-time'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Eating Time
                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('hostel/food/category*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('hostel.food.category'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Food Category
                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('hostel/food/item*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('hostel.food.item'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Food Item
                                </a>
                                <b class="arrow"></b>
                            </li>
                        </ul>
                    </li>
                </ul>
            </li>
        <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        
        <?php if (\Entrust::ability('super-admin','transport')) : ?>
        <?php if( isset($generalSetting) && $generalSetting->transport ==1): ?>
            <li class="<?php echo request()->is('transport*')?'active':''; ?> hover">
                <a href="#" class="dropdown-toggle">
                    <i class="menu-icon  fa fa-bus" aria-hidden="true"></i>
                    <span class="menu-text"> <?php echo e(__('transport.name'), false); ?> </span>

                    <b class="arrow fa fa-angle-down"></b>
                </a>
                <b class="arrow"></b>
                <ul class="submenu">
                    <li class="<?php echo request()->is('transport/user*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('transport.user'), false); ?>" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Traveller/User
                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('transport/user')?'active':''; ?> hover">
                                <a href="<?php echo e(route('transport.user'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Detail
                                </a>
                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('transport/user/add')?'active':''; ?> hover">
                                <a href="<?php echo e(route('transport.user.add'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    Registration
                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('transport/user/history')?'active':''; ?> hover">
                                <a href="<?php echo e(route('transport.user.history'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    User History
                                </a>
                                <b class="arrow"></b>
                            </li>

                        </ul>
                    </li>
                    <li class="<?php echo request()->is('transport/route*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('transport.route'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Route
                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                    </li>

                    <li class="<?php echo request()->is('transport/vehicle*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('transport.vehicle'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            Vehicle
                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                    </li>

                </ul>
            </li>
        <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        
        

        <?php if (\Entrust::ability('super-admin','assignment')) : ?>
        <?php if( isset($generalSetting) && $generalSetting->assignment ==1): ?>
            <li class="<?php echo request()->is('assignment')?'active':''; ?> hover">
                <a href="<?php echo e(route('assignment'), false); ?>">
                    <i class="menu-icon fa fa-tasks"></i>
                    <?php echo e(__('assignment.name'), false); ?>

                </a>
                <b class="arrow"></b>
            </li>
        <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        <?php if (\Entrust::ability('super-admin','application')) : ?>
        <?php if( isset($generalSetting) && $generalSetting->application ==1): ?>
            <li class="<?php echo request()->is('application*')?'active':''; ?> hover">
                <a href="<?php echo e(route('application.index'), false); ?>">
                    <i class="menu-icon fa fa-files-o"></i>
                    <?php echo e(__('application.name'), false); ?>

                </a>
                <b class="arrow"></b>
            </li>
        <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        <?php if (\Entrust::ability('super-admin','download')) : ?>
        <?php if( isset($generalSetting) && $generalSetting->upload_download ==1): ?>
            <li class="<?php echo request()->is('download*')?'active':''; ?> hover">
                <a href="<?php echo e(route('download'), false); ?>">
                    <i class="menu-icon fa fa-download"></i>
                    <?php echo e(__('upload_download.name'), false); ?>

                    <b class="arrow"></b>
                </a>
            </li>
        <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        <?php if (\Entrust::ability('super-admin','meeting')) : ?>
        <?php if( isset($generalSetting) && $generalSetting->meeting ==1): ?>
            <li class="<?php echo request()->is('meeting*')?'active':''; ?> hover">
                <a href="<?php echo e(route('meeting'), false); ?>">
                    <i class="menu-icon fa fa-video-camera"></i>
                    <?php echo e(__('meeting.name'), false); ?>

                    <b class="arrow"></b>
                </a>
            </li>
        <?php endif; ?>
        <?php endif; // Entrust::ability ?>


        
        <?php if (\Entrust::ability('super-admin','report')) : ?>
        
        <?php endif; // Entrust::ability ?>

        
        <?php if (\Entrust::ability('super-admin','alert-center')) : ?>
        <?php if( isset($generalSetting) && $generalSetting->alert ==1): ?>
            <li class="<?php echo request()->is('info*')?'active':''; ?> hover">
                <a href="#" class="dropdown-toggle">
                    <i class="menu-icon fa fa-bullhorn" aria-hidden="true"></i>
                    <span class="menu-text">
                    <?php echo e(__('alert.name'), false); ?>

                    </span>

                    <b class="arrow fa fa-angle-down"></b>
                </a>
                <b class="arrow"></b>
                <ul class="submenu">
                    <li class="<?php echo request()->is('info/notice*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('info.notice'), false); ?>" >
                            <i class="menu-icon fa fa-caret-right"></i>
                            User Notice
                        </a>

                        <b class="arrow"></b>
                    </li>
                    <li class="<?php echo request()->is('info/smsemail*')?'active':''; ?> hover">
                        <a href="<?php echo e(route('info.smsemail'), false); ?>">
                            <i class="menu-icon fa fa-caret-right"></i>
                            SMS / E-mail
                        </a>

                        <b class="arrow"></b>
                    </li>

                </ul>
            </li>
        <?php endif; ?>
        <?php endif; // Entrust::ability ?>

        
        <?php if (\Entrust::ability('super-admin','academic')) : ?>
        <?php if( isset($generalSetting) && $generalSetting->academic ==1): ?>
            <li class="hover">
                <a href="#" class="dropdown-toggle">
                    <i class="menu-icon  fa fa-graduation-cap" aria-hidden="true"></i>
                    <span class="menu-text">
                    <?php echo e(__('academic.name'), false); ?>

                    </span>
                    <b class="arrow fa fa-angle-down"></b>
                </a>

                <b class="arrow"></b>

                <ul class="submenu">
                    <li class="<?php echo request()->is('faculty*') || request()->is('semester*')?'active':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('academic.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('department-head*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('department-head'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.academic_level.child.department_head'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('department*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('department'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.academic_level.child.department'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>



                            <li class="<?php echo request()->is('faculty*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('faculty'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.academic_level.child.faculty'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('semester*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('semester'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.academic_level.child.semester'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('student-batch*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('student-batch'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.academic_level.child.batch'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>
                        </ul>
                    </li>
                    <li class="<?php echo request()->is('grading*') || request()->is('subject*')?'active':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                                <?php echo e(__('academic.child.grading_subject.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('subject*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('subject'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.grading_subject.child.subject'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('grading*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('grading'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.grading_subject.child.grading'), false); ?>

                                </a>
                                <b class="arrow"></b>
                            </li>
                        </ul>
                    </li>

                    <li class="<?php echo request()->is('year*') || request()->is('month*')?'active':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('academic.child.year_month_day.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('year*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('year'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.year_month_day.child.year'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('month*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('month'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.year_month_day.child.month'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('day*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('day'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.year_month_day.child.day'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                        </ul>
                    </li>

                    <li class="<?php echo request()->is('*status')?'active':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('academic.child.status_setting.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('student-status*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('student-status'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.status_setting.child.student_status'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('attendance-status*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('attendance-status'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.status_setting.child.attendance_status'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('book-status*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('book-status'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.status_setting.child.book_status'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('bed-status*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('bed-status'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.status_setting.child.hostel_bed_status'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('customer-status*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('customer-status'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.status_setting.child.customer_status'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                        </ul>
                    </li>

                    <li class="<?php echo request()->is('dynamic*')?'active':''; ?> hover">
                        <a href="#" class="dropdown-toggle">
                            <i class="menu-icon fa fa-caret-right"></i>
                            <?php echo e(__('academic.child.dynamic_gallery.name'), false); ?>

                            <b class="arrow"></b>
                        </a>
                        <b class="arrow"></b>
                        <ul class="submenu">
                            <li class="<?php echo request()->is('dynamic/placement*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('dynamic.placement'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.dynamic_gallery.child.placement'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('dynamic/scholarship*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('dynamic.scholarship'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.dynamic_gallery.child.scholarship'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('dynamic/annexure*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('dynamic.annexure'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.dynamic_gallery.child.annexure'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>

                            <li class="<?php echo request()->is('dynamic/academic-info-level*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('dynamic.academic-info-level'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.dynamic_gallery.child.academic_info_level'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('dynamic/degree*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('dynamic.degree'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.dynamic_gallery.child.degree'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('dynamic/state*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('dynamic.state'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.dynamic_gallery.child.state'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('dynamic/application-type*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('dynamic.application-type'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.dynamic_gallery.child.application_type'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                            <li class="<?php echo request()->is('dynamic/payment-method*')?'active':''; ?> hover">
                                <a href="<?php echo e(route('dynamic.payment-method'), false); ?>">
                                    <i class="menu-icon fa fa-caret-right"></i>
                                    <?php echo e(__('academic.child.dynamic_gallery.child.payment_method'), false); ?>

                                </a>

                                <b class="arrow"></b>
                            </li>
                        </ul>
                    </li>
                </ul>
            </li>
        <?php endif; ?>
        <?php endif; // Entrust::ability ?>



        
        <?php if (\Entrust::ability('super-admin','admin')) : ?>
            <?php if( isset($generalSetting) && $generalSetting->help ==1): ?>
                <li class="hover">
                    <a href="#" target="_blank" class="dropdown-toggle">
                        <i class="menu-icon  fa fa-question" aria-hidden="true"></i>
                        <span class="menu-text">
                        <?php echo e(__('help.name'), false); ?>

                        </span>
                        <b class="arrow fa fa-angle-down"></b>
                    </a>

                    <b class="arrow"></b>

                    <ul class="submenu">
                        <li class="hover">
                            <a href="<?php echo e(route('license-info'), false); ?>" target="_self">
                                <i class="menu-icon fa fa-caret-right"></i>
                                License Info
                            </a>
                        </li>
                        <li class="hover">
                            <a href="http://unlimitededufirm.com/demo-detail" target="_blank">
                                <i class="menu-icon fa fa-caret-right"></i>
                                Test Demo
                            </a>
                        </li>
                        <li class="hover">
                            <a href="https://www.youtube.com/watch?v=2jgA9WY8IzQ&list=PLCtD_CGPAQJ2zSk5cDUkkfWGdtMGsF9n0" target="_blank">
                                <i class="menu-icon fa fa-caret-right"></i>
                                Video Tutorial
                            </a>
                        </li>
                        <li class="hover">
                            <a href="http://docs.unlimitededufirm.com" target="_blank">
                                <i class="menu-icon fa fa-caret-right"></i>
                                Documentation
                            </a>
                        </li>
                        <li class="hover">
                            <a href="https://codecanyon.net/item/unlimited-edu-firm-school-college-information-management-system/21850988" target="_blank">
                                <i class="menu-icon fa fa-caret-right"></i>
                                Buy New License
                            </a>
                        </li>
                    </ul>
                </li>
            <?php endif; ?>
        <?php endif; // Entrust::ability ?>
    </ul><!-- /.nav-list -->
</div>

<?php /**PATH C:\laragon\www\edufirm\resources\views/layouts/includes/menu.blade.php ENDPATH**/ ?>