<div class="table-responsive">
    <table id="dynamic-table" class="table table-striped table-bordered table-hover">
        <thead>
            <tr>
                <th><?php echo e(__('common.s_n'), false); ?></th>
                <th><?php echo e(__('form_fields.student.fields.reg_no'), false); ?></th>
                <th>Staff Name</th>
                <th>Designation</th>
                <th>DateofBirth</th>
                
            </tr>
        </thead>
        <tbody>
        <?php if(isset($data['staff_birthday']) && $data['staff_birthday']->count() > 0): ?>
            <?php ($i=1); ?>
            <?php ($todayMonthDay = today()->format('m-d')); ?>
            <?php $__currentLoopData = $data['staff_birthday']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $staff): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($i, false); ?></td>
                    <td><a href="<?php echo e(route('staff.view', ['id' => encrypt($staff->id)]), false); ?>"><?php echo e($staff->reg_no, false); ?></a></td>
                    <td><a href="<?php echo e(route('staff.view', ['id' => encrypt($staff->id)]), false); ?>"> <?php echo e($staff->first_name.' '.$staff->middle_name.' '. $staff->last_name, false); ?></a></td>
                    <td><?php echo e(ViewHelper::getDesignationId($staff->designation), false); ?></td>
                    <td>
                        <?php ($birthdayMonthDay = \Carbon\Carbon::parse($staff->date_of_birth)->format('m-d')); ?>
                        <?php if($todayMonthDay ==$birthdayMonthDay): ?>
                            <div class="label label-success ">
                                <?php echo e(\Carbon\Carbon::parse($staff->date_of_birth)->format('Y-m-d'), false); ?>

                            </div>
                        <?php else: ?>
                            <?php echo e(\Carbon\Carbon::parse($staff->date_of_birth)->format('Y-m-d'), false); ?>

                        <?php endif; ?>
                    </td>
                    
                </tr>
                <?php ($i++); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <tr>
                <td colspan="11">No <?php echo e($panel, false); ?> data found. Please Filter <?php echo e($panel, false); ?> to show. </td>
            </tr>
        <?php endif; ?>
        </tbody>
        <tfoot>
            <tr>
                <td class="text-center" colspan="5"><?php echo $data['staff_birthday']->appends($data['filter_query'])->links(); ?></td>
            </tr>
        </tfoot>
    </table>
</div>
<?php /**PATH C:\laragon\www\edufirm\resources\views/dashboard/includes/birthday/staff.blade.php ENDPATH**/ ?>